IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_NF_ENT_DANFE_PROVISORIO_HISTORICO]'))
DROP VIEW [dbo].[V_EST_NF_ENT_DANFE_PROVISORIO_HISTORICO]
GO

--SELECT * FROM V_EST_NF_ENT_DANFE_PROVISORIO_HISTORICO WHERE (CD_CTR = 268920 OR NR_AUTORIZADOR='42170404892290000852550010000631041316370174') 
CREATE VIEW [dbo].[V_EST_NF_ENT_DANFE_PROVISORIO_HISTORICO] AS
 SELECT
	0 as CD_CTR,
	0 as CD_CTR_CPL,
	d.NR_AUTORIZADOR,
	'XML em DOWNLOAD Filial.: ' + CONVERT(VARCHAR(10),d.CD_FILIAL)
	 +  ' cadastro.: ' + CONVERT(VARCHAR(10),d.DT_CAD,103) + ' ' + CONVERT(VARCHAR(5),d.DT_CAD,114) 
	 + ' status.: ' + CASE WHEN STS_IMP=2 THEN 
			'com erro no download ' + MSG_SEFAZ
		WHEN STS_IMP=1 THEN 
			'importado' 
		ELSE 
			'pendente' 
		END  AS PROCESSO,
	0 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_DOWNLOAD d 
UNION ALL
SELECT
	0 as CD_CTR,
	ID as CD_CTR_CPL,
	d.CHAVE_NFE AS NR_AUTORIZADOR,
	'XML recebido Filial.: ' + CONVERT(VARCHAR(10),d.CD_FILIAL) +  ' cadastro.: ' + CONVERT(VARCHAR(10),d.DH_IMPORT,103) 
	+ ' ' + CONVERT(VARCHAR(5),d.DH_IMPORT,114) + 
	' status.: ' + CASE WHEN STS_IMPORT=0 THEN 
					'Pendente importacao' 
				   WHEN STS_IMPORT=1 THEN 
					 'Armazenado' 
				   WHEN STS_IMPORT=2 THEN 
					 'Erro de importacao gerado pelo  InterfaceNFe, ver laudo no painel NFe.' 
				   WHEN STS_IMPORT=3 THEN 
					 'Rejeitado via painel NFe'
				   WHEN STS_IMPORT=4 THEN 
					 'Reprocessando para armazenar' 
				   WHEN STS_IMPORT=5 THEN 
					 'Danfe ja importado' 
				   WHEN STS_IMPORT=6 THEN 
					 'Aguardando reprocessamento'
				    ELSE 
					  'Nao definido' 
					END  AS PROCESSO,
			1 AS TRANSACAO
FROM
	EST_NF_NFE_RECEBIMENTO d
UNION 
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Dados do XML Filial.: ' collate SQL_Latin1_General_CP1_CI_AS + CONVERT(VARCHAR(10),CD_FILIAL) + ' emissao.: ' + CONVERT(VARCHAR(10),DT_EMIS_NF,103) + ' importacao.: ' + CONVERT(VARCHAR(10),DT_CAD,103) + ' ' + CONVERT(VARCHAR(5),DT_CAD,114) + ' XPed.: ' + CONVERT(VARCHAR(20),CD_PED_FORN)collate SQL_Latin1_General_CP1_CI_AS AS PROCESSO,
	2 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Chave NFe.: ' + NR_AUTORIZADOR + ' numero nota fiscal.: ' + CONVERT(VARCHAR(30),NR_NF) + ' protocolo.: ' + convert(varchar,NPROT,150)  AS PROCESSO,
	3 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Fornecedor.: ' + CONVERT(VARCHAR(30),EST_NF_ENT_DANFE_PROVISORIO.CD_FORN) + ' - ' + PG_FORN.RZ_FORN  AS PROCESSO,
	4 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO INNER JOIN PG_FORN ON
	EST_NF_ENT_DANFE_PROVISORIO.CD_EMP = PG_FORN.CD_EMP AND
	EST_NF_ENT_DANFE_PROVISORIO.CD_FORN = PG_FORN.CD_FORN
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Pendente de entrada em.: ' + CONVERT(VARCHAR(10),DT_CAD,103) + ' ' + CONVERT(VARCHAR(5),DT_CAD,114) AS PROCESSO,
	5 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_PENDENTE
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' collate SQL_Latin1_General_CP1_CI_AS AS NR_AUTORIZADOR,
	'Ciencia da operacao (manisfesto SEFAZ) em.: 'collate SQL_Latin1_General_CP1_CI_AS  + CONVERT(VARCHAR(10),EST_NF_ENT_DANFE_PROVISORIO_CIENCIA_OPERACAO.DT_CAD,103)COLLATE SQL_Latin1_General_CP1_CI_AS + ' ' + CONVERT(VARCHAR(5),EST_NF_ENT_DANFE_PROVISORIO_CIENCIA_OPERACAO.DT_CAD,114) + ' protocolo.: ' + convert(varchar,NR_PROTOCOLO,150) COLLATE SQL_Latin1_General_CP1_CI_AS AS PROCESSO,
	6 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_CIENCIA_OPERACAO
UNION ALL 
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Recebimento do DANFE na loja em.: ' + CONVERT(VARCHAR(10),EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_RECBTO.DT_CAD,103) + + ' ' + CONVERT(VARCHAR(5),EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_RECBTO.DT_CAD,114) + ' pelo usuario.: ' + NM_USU  AS PROCESSO,
	7 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_RECBTO INNER JOIN GLB_USU ON
	EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_RECBTO.CD_USU = GLB_USU.CD_USU
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Bloqueio de entrada pendente.: ' + DS_TIPO_BLQ  AS PROCESSO,
	8 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE bp INNER JOIN V_EST_NF_ENT_DANFE_PROVISORIO_TIPO_BLOQUEIO t ON
	bp.TIPO_BLQ = t.TIPO_BLQ
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Erro de entrada automatica no painel NFE em ' + CONVERT(VARCHAR(10),EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO.DT_CAD_CORRECAO,103) + + ' ' + CONVERT(VARCHAR(5),EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO.DT_CAD_CORRECAO,114) AS PROCESSO,
	9 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Bloqueado a entrada em .: ' + DS_TIPO_BLQ  + ' em ' + CONVERT(VARCHAR(10),b.DT_CAD,103)COLLATE SQL_Latin1_General_CP1_CI_AS +  ' pelo usuario.: ' + GLB_USU.NM_USU ,
	10 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO B INNER JOIN GLB_USU ON
	B.CD_USU = GLB_USU.CD_USU
	INNER JOIN V_EST_NF_ENT_DANFE_PROVISORIO_TIPO_BLOQUEIO t ON
	b.TIPO_BLQ = t.TIPO_BLQ
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Liberado a entrada do tipo.: ' + DS_TIPO_BLQ + ' em ' +  CONVERT(VARCHAR(10),l.DT_HR_CAD,103) + ' ' + CONVERT(VARCHAR(5),l.DT_HR_CAD,114)COLLATE SQL_Latin1_General_CP1_CI_AS + ' pelo usuario.: ' + GLB_USU.NM_USU  + ' OBS.: ' + ISNULL(L.OBS_LIB,''),
	11 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO_TIPO_BLQ L INNER JOIN GLB_USU ON
	L.CD_USU_LIB = GLB_USU.CD_USU
	INNER JOIN V_EST_NF_ENT_DANFE_PROVISORIO_TIPO_BLOQUEIO t ON
	L.TIPO_BLQ = t.TIPO_BLQ
UNION ALL
SELECT
	L.CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Liberado a entrada do tipo.: ' + DS_TIPO_BLQ + ' em ' + CONVERT(VARCHAR(10),l.DT_HR_CAD,103)COLLATE SQL_Latin1_General_CP1_CI_AS + ' ' + CONVERT(VARCHAR(5),l.DT_HR_CAD,114) + ' pelo usuario.: ' + GLB_USU.NM_USU,
	12 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO L INNER JOIN GLB_USU ON
	L.CD_USU_LIB = GLB_USU.CD_USU
	INNER JOIN V_EST_NF_ENT_DANFE_PROVISORIO_TIPO_BLOQUEIO t ON
	L.TIPO_BLQ = t.TIPO_BLQ
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO_TIPO_BLQ ON
	L.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO_TIPO_BLQ.CD_CTR AND
	L.TIPO_BLQ = EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO_TIPO_BLQ.TIPO_BLQ
WHERE
	EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO_TIPO_BLQ.CD_CTR IS NULL
UNION ALL
SELECT 
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Danfe com vinculo com a pre-entrada..: '  + CONVERT(VARCHAR(10),EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA) + ' em ' + CONVERT(VARCHAR(10),EST_NF_ENT_PRE_ENTRADA.DT_CAD,103)COLLATE SQL_Latin1_General_CP1_CI_AS  + ' ' + CONVERT(VARCHAR(5),EST_NF_ENT_PRE_ENTRADA.HR_ULT_ATU,114) + ' pelo usuario.: ' + NM_USU AS PROCESSO,
	13 AS TRANSACAO		
FROM 
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA INNER JOIN EST_NF_ENT_PRE_ENTRADA ON
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_EMP = EST_NF_ENT_PRE_ENTRADA.CD_EMP AND
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA = EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA
	INNER JOIN GLB_USU ON
	EST_NF_ENT_PRE_ENTRADA.CD_USU = GLB_USU.CD_USU 
UNION ALL
SELECT 
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Ordem de entrada WMS..: '  + CONVERT(VARCHAR(10),EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_PED_WMS) + ' em ' + CONVERT(VARCHAR(10),EST_WMS_ENT.DT_CAD,103)  + ' ' + CONVERT(VARCHAR(5),EST_WMS_ENT.DT_CAD,114) 
	 + ' status.: ' + CASE WHEN EST_WMS_ENT_PEND.CD_PED_WMS IS NULL THEN
		CASE WHEN NOT EST_WMS_ENT_RET.CD_PED_WMS IS NULL THEN
			CASE WHEN EST_WMS_ENT_RET_PEND.CD_PED_WMS IS NULL THEN
				'FINALIZADO PELO WMS'
			ELSE
				'PENDENTE DE ENVIO RETORNO DO WMS'
			END
		ELSE
			'SEM RETORNO WMS'
		END
	ELSE
		'PENDENTE DE ENVIO AO WMS'
	END AS PROCESSO,	
	14 AS TRANSACAO		
FROM 
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA INNER JOIN EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT ON
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_EMP = EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_EMP AND
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA = EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_CTR_PRE_ENTRADA
	INNER JOIN EST_WMS_ENT ON
	EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_PED_WMS = EST_WMS_ENT.CD_PED_WMS
	LEFT JOIN EST_WMS_ENT_PEND ON 
	EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_PED_WMS = EST_WMS_ENT_PEND.CD_PED_WMS
	LEFT JOIN 
		(SELECT
			DISTINCT CD_PED_WMS
		FROM
			EST_WMS_ENT_RET) EST_WMS_ENT_RET ON		
	EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_PED_WMS = EST_WMS_ENT_RET.CD_PED_WMS
	LEFT JOIN 
		(SELECT
			DISTINCT CD_PED_WMS
		FROM
			EST_WMS_ENT_RET_PEND) EST_WMS_ENT_RET_PEND ON		
	EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_PED_WMS = EST_WMS_ENT_RET_PEND.CD_PED_WMS
UNION ALL
SELECT
	EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA.CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Checkin realizado .: ' + CONVERT(VARCHAR(10),EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA.DT_CAD,103) + ' gravacao.: ' + CONVERT(VARCHAR(10),EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA.DT_TRANSACAO,103) + ' ' + CONVERT(VARCHAR(5),EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA.DT_TRANSACAO,114) + ' pelo usuario.: ' + NM_USU AS PROCESSO,
	15 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA INNER JOIN GLB_USU ON
	EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA.CD_USU = GLB_USU.CD_USU 
UNION ALL
SELECT
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Entrada.: ' + CONVERT(VARCHAR(10),DT_ENT,103) + ' gravacao.: ' + CONVERT(VARCHAR(10),EST_NF_ENT.DT_CAD,103) + ' ' + CONVERT(VARCHAR(5),HR_EMI_NF,114) + ' XPed.: ' + CONVERT(VARCHAR(20),EST_NF_ENT.NR_PED_FORN)  + ' pelo usuario.: ' + NM_USU AS PROCESSO,
	16 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT INNER JOIN EST_NF_ENT ON
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_EMP = EST_NF_ENT.CD_EMP AND
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_FILIAL = EST_NF_ENT.CD_FILIAL AND
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_NF = EST_NF_ENT.CD_NF 
	INNER JOIN GLB_USU ON
	EST_NF_ENT.CD_USU = GLB_USU.CD_USU 
UNION ALL
SELECT
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Duplicata.: ' + CONVERT(VARCHAR(30), PG_CRED_DUP_NR_CTR.NR_DP) 
	+ ' parc.: ' + CONVERT(VARCHAR(30), MAX(PG_CRED_EST_NF_ENT.PARC)) 
	+ ' valor.: ' +CONVERT(VARCHAR(30), SUM(PG_CRED.VLR_DP))
	+ ' vencto.: ' + CONVERT(VARCHAR(10), PG_CRED.DT_VENCTO,103),
	17 AS TRANSACAO
FROM
	PG_CRED_EST_NF_ENT INNER JOIN  PG_CRED_DUP_NR_CTR ON
	PG_CRED_EST_NF_ENT.CD_EMP = PG_CRED_DUP_NR_CTR.CD_EMP AND
	PG_CRED_EST_NF_ENT.CD_FILIAL = PG_CRED_DUP_NR_CTR.CD_FILIAL AND
	PG_CRED_EST_NF_ENT.NR_DP = PG_CRED_DUP_NR_CTR.NR_DP AND 
	PG_CRED_EST_NF_ENT.ANO = PG_CRED_DUP_NR_CTR.ANO
	INNER JOIN PG_CRED ON    
	PG_CRED_DUP_NR_CTR.CD_EMP = PG_CRED.CD_EMP AND 
	PG_CRED_DUP_NR_CTR.CD_FILIAL = PG_CRED.CD_FILIAL AND
	PG_CRED_DUP_NR_CTR.NR_DP = PG_CRED.NR_DP AND
	PG_CRED_DUP_NR_CTR.ANO = PG_CRED.ANO 
	INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT ON
	PG_CRED_EST_NF_ENT.CD_EMP = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_EMP AND
	PG_CRED_EST_NF_ENT.CD_FILIAL = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_FILIAL AND
	PG_CRED_EST_NF_ENT.CD_NF = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_NF 
GROUP BY 
    PG_CRED_DUP_NR_CTR.NR_DP, 
    PG_CRED.DT_CAD,
	PG_CRED.DT_VENCTO,
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR
UNION ALL
SELECT
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Data vinculacao com o pedido de compras.: ' + CONVERT(VARCHAR(10),EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.CD_PED) + ' em ' +  CONVERT(VARCHAR(10),EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.DT_CAD,103) + ' ' + CONVERT(VARCHAR(5),EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.DT_CAD,114) + ' pelo usuario.: ' + NM_USU AS PROCESSO,
	18 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP INNER JOIN GLB_USU ON
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.CD_USU = GLB_USU.CD_USU 
UNION ALL
SELECT
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR,
	0 as CD_CTR_CPL,
	'' collate SQL_Latin1_General_CP1_CI_AS AS NR_AUTORIZADOR,
	'Criacao pedido de compras.: 'collate SQL_Latin1_General_CP1_CI_AS + CONVERT(VARCHAR(10),EST_PED_CP.CD_PED) + ' em ' + CONVERT(VARCHAR(10),EST_PED_CP.DT_EMI,103) + ' gravacao.: ' + CONVERT(VARCHAR(10),ISNULL(EST_PED_CP.DT_HR_CAD,''),103) + ' ' + CONVERT(VARCHAR(5),ISNULL(EST_PED_CP.DT_HR_CAD,''),114) + ' XPed.: ' + CONVERT(VARCHAR(20),ISNULL(EST_PED_CP.CD_PED_FORN,'')) + ' pelo usuario.: ' + NM_USU AS PROCESSO,
	19 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT  INNER JOIN EST_NF_ENT ON
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_EMP = EST_NF_ENT.CD_EMP AND
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_FILIAL = EST_NF_ENT.CD_FILIAL AND
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_NF = EST_NF_ENT.CD_NF 
	INNER JOIN EST_NF_ENT_PED_CP ON
	EST_NF_ENT.CD_EMP = EST_NF_ENT_PED_CP.CD_EMP AND
	EST_NF_ENT.CD_FILIAL = EST_NF_ENT_PED_CP.CD_FILIAL AND
	EST_NF_ENT.CD_NF = EST_NF_ENT_PED_CP.CD_NF 
	INNER JOIN EST_PED_CP ON
	EST_NF_ENT_PED_CP.CD_EMP = EST_PED_CP.CD_EMP AND
	EST_NF_ENT_PED_CP.CD_FILIAL = EST_PED_CP.CD_FILIAL AND
	EST_NF_ENT_PED_CP.CD_PED = EST_PED_CP.CD_PED 
	INNER JOIN GLB_USU ON
	EST_PED_CP.CD_USU = GLB_USU.CD_USU 
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Desconhecimento de operacao (manisfesto SEFAZ)  em ' + CONVERT(VARCHAR(10),EST_NF_ENT_DANFE_PROVISORIO_DESCONHECIMENTO_OPERACAO.DT_CAD,103) + ' protocolo.: ' + convert(varchar,NR_PROTOCOLO,150),
	20 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_DESCONHECIMENTO_OPERACAO
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Confirmacao de operacao (manisfesto SEFAZ)  em ' + CONVERT(VARCHAR(10),EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_OPERACAO.DT_CAD,103) + ' ' + CONVERT(VARCHAR(5),EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_OPERACAO.DT_CAD,114) + ' protocolo.: ' + convert(varchar,NR_PROTOCOLO,150) AS PROCESSO,
	21 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_OPERACAO
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	CASE WHEN ISNULL(FLAG_LIBERA_ENTRADA_SEM_PEDIDO,0) =0 THEN
		'Entrada bloqueado sem pedido'
	ELSE
		'Entrada liberada sem pedido'
	END + ' pelo usuario.: ' + NM_USU AS PROCESSO,
	22 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO INNER JOIN GLB_USU ON
	EST_NF_ENT_DANFE_PROVISORIO.CD_USU_LIBEROU_ENTRADA = GLB_USU.CD_USU
WHERE	
	EST_NF_ENT_DANFE_PROVISORIO.CD_USU_LIBEROU_ENTRADA > 0
UNION ALL
SELECT
	CD_CTR,
	0 as CD_CTR_CPL,
	'' AS NR_AUTORIZADOR,
	'Danfe suspenso (cancelamento entrada) a entrada.: ' + CONVERT(VARCHAR(10),EST_NF_ENT_DANFE_PROVISORIO_SUSPENSO.DT_CAD,103)  + ' pelo usuario.: ' + NM_USU AS PROCESSO,
	23 AS TRANSACAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_SUSPENSO INNER JOIN GLB_USU ON
	EST_NF_ENT_DANFE_PROVISORIO_SUSPENSO.CD_USU = GLB_USU.CD_USU
UNION ALL
SELECT
	0 as CD_CTR,
	0 as CD_CTR_CPL,
	d.NR_AUTORIZADOR,
	'Validacao do status da nota fiscal junto a SEFAZ em .: ' + CONVERT(VARCHAR(10),d.DT_VALIDACAO,103) + ' ' + CONVERT(VARCHAR(5),d.DT_VALIDACAO,114) 
	 + ' cancelada.: ' + CASE WHEN D.CANCELADA_SEFAZ > 0 THEN 'SIM' ELSE 'NAO' END,
	24 AS TRANSACAO
FROM
	EST_NF_ENT_NFE_FORN_VALID d 

GO


